/* - StepperPositionListener -
 * Display the position data from the position change event
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.StepperPhidget;
import com.phidgets.event.StepperPositionChangeListener;
import com.phidgets.event.StepperPositionChangeEvent;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class StepperPositionListener implements StepperPositionChangeListener{
    
    private JComboBox motorCmb;
    private JTextField posActualTxt;
    private JCheckBox stoppedChk;
    private JSlider currentPosScrl;
    private JFrame appFrame;
    
    /**
     * Creates a new instance of StepperPositionListener
     */
    public StepperPositionListener(JFrame appFrame, JComboBox motorCmb, JTextField posActualTxt, JCheckBox stoppedChk, JSlider currentPosScrl)
    {
        this.appFrame = appFrame;
        this.motorCmb = motorCmb;
        this.posActualTxt = posActualTxt;
        this.stoppedChk = stoppedChk;
        this.currentPosScrl = currentPosScrl;
    }

    public void stepperPositionChanged(StepperPositionChangeEvent stepperPositionChangeEvent)
    {
        if(stepperPositionChangeEvent.getIndex() == ((Integer)motorCmb.getSelectedItem()).intValue())
        {
            try
            {
                posActualTxt.setText(Double.toString(stepperPositionChangeEvent.getValue()));
                stoppedChk.setSelected(((StepperPhidget)stepperPositionChangeEvent.getSource()).getStopped(stepperPositionChangeEvent.getIndex()));
                if(!currentPosScrl.isFocusOwner())
                {
                    currentPosScrl.setEnabled(((StepperPhidget)stepperPositionChangeEvent.getSource()).getStopped(stepperPositionChangeEvent.getIndex()));
                }
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    
}
